<?php
/**
 * The Template for displaying all single posts.
 * @package intact
 * by KeyDesign
 */

get_header(); ?>

<?php
  $blog_sidebar = intact_get_option( 'tek-blog-sidebar' );
  $blog_active_widgets = is_active_sidebar( 'blog-sidebar' );

  if( '' == $blog_sidebar ) {
    $blog_sidebar = 1;
  }

  if ( ! $blog_active_widgets ) {
		$blog_sidebar = 0;
	}
?>

<div id="posts-content" class="container blog-single">
<?php if ( $blog_sidebar ) { ?>
    <div class="col-xs-12 col-sm-12 col-md-9 col-lg-9">
<?php } else { ?>
    <div class="col-xs-12 col-sm-12 col-md-9 col-lg-9 BlogFullWidth">
<?php } ?>
      <?php
          if ( have_posts() ) : the_post();
          get_template_part( 'core/templates/blog-single/format', 'standard' );
      ?>
      <?php do_action( 'keydesign_after_post_content' ); ?>
      <div class="page-content comments-content">
          <?php
              // If comments are open or we have at least one comment, load up the comment template
              if ( comments_open() || '0' != get_comments_number() ) {
                  comments_template();
              }
          ?>
      </div>
   </div>
   <?php if ( $blog_sidebar ) { ?>
       <div class="col-xs-12 col-sm-12 col-md-3 col-lg-3">
          <?php get_sidebar(); ?>
       </div>
   <?php } ?>
   <?php else : ?>
       <div id="post-not-found" <?php post_class() ?>>
          <h1 class="entry-title"><?php esc_html_e('Error 404 - Not Found', 'intact')   ?></h1>
          <div class="entry-content">
             <p><?php esc_html_e("Sorry, but you are looking for something that isn't here.", "intact"); ?></p>
          </div>
       </div>
   <?php endif; ?>
</div>

<?php get_footer(); ?>
