<?php
/**
 * The template for displaying Search Results pages.
 * @package intact
 * by KeyDesign
 */

 get_header(); ?>

 <?php
   $blog_sidebar = intact_get_option( 'tek-blog-sidebar' );
   $blog_active_widgets = is_active_sidebar( 'blog-sidebar' );

   if( '' == $blog_sidebar ) {
     $blog_sidebar = 1;
   }

   if ( ! $blog_active_widgets ) {
 		$blog_sidebar = 0;
 	}
 ?>

<div id="posts-content" class="container">
  <?php if ( $blog_sidebar ) : ?>
    <div class="col-xs-12 col-sm-12 col-md-9 col-lg-9">
  <?php else : ?>
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
  <?php endif; ?>
    	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
    		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> >
				<h3 class="blog-single-title"><a href="<?php esc_url(the_permalink()); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
				<?php if ( 'post' === get_post_type() ) : ?>
					<div class="entry-meta">
						<span class="page-type"><span class="fa fa-file-text-o"></span><?php _e( 'Post', 'intact' ); ?></span>
						<span class="published"><span class="fa fa-clock-o"></span><a href="<?php esc_url(the_permalink()); ?>" title="<?php the_title_attribute(); ?>"><?php  the_time( get_option('date_format') ); ?></a></span>
						<span class="author"><span class="fa fa-keyboard-o"></span><?php  the_author_posts_link(); ?></span>
						<span class="blog-label"><span class="fa fa-folder-open-o"></span><?php  the_category(', '); ?></span>
						<span class="comment-count"><span class="fa fa-comment-o"></span><?php  comments_popup_link( esc_html__('No comments yet', 'intact'), esc_html__('1 comment', 'intact'), esc_html__('% comments', 'intact') ); ?></span>
					</div>
				<?php else : ?>
					<div class="entry-meta">
						<?php if ( 'page' === get_post_type() ) : ?>
							<span class="page-type"><span class="fa fa-file-text-o"></span><?php _e( 'Page', 'intact' ); ?></span>
						<?php elseif ( 'portfolio' === get_post_type() ) : ?>
							<span class="page-type"><span class="fa fa-file-image-o"></span><?php _e( 'Portfolio', 'intact' ); ?></span>
						<?php elseif ( 'product' === get_post_type() ) : ?>
							<span class="page-type"><span class="fa fa-shopping-cart"></span><?php _e( 'Product', 'intact' ); ?></span>
						<?php endif; ?>
						<span class="published"><span class="fa fa-clock-o"></span><a href="<?php esc_url(the_permalink()); ?>" title="<?php the_title_attribute(); ?>"><?php  the_time( get_option('date_format') ); ?></a></span>
					</div>
				<?php endif; ?>
			</article>

		<?php endwhile; ?>
		<?php the_posts_pagination( array(
			'mid_size' => 1,
			'prev_text' => __( 'Previous', 'intact' ),
			'next_text' => __( 'Next', 'intact' ),
		) ); ?>
		<?php else : ?>
			<section id="no-posts-found">
				<div class="row" >
					<h2 class="section-title"><?php esc_html_e( 'Nothing Found', 'intact' ); ?></h2>
					<?php
					if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
						<p><?php printf( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'intact' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>
					<?php elseif ( is_search() ) : ?>
						<p class="section-subheading"><?php _e( 'Sorry, but nothing matched your search terms. Please try again using different keywords.', 'intact' ); ?></p>
						<?php get_search_form();
					else : ?>
						<p><?php _e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'intact' ); ?></p>
						<?php get_search_form();
					endif; ?>
				</div>
			</section>
		<?php endif; ?>
    </div>
    <?php if ( $blog_sidebar ) : ?>
		<div class="col-xs-12 col-sm-12 col-md-3 col-lg-3">
			<?php get_sidebar(); ?>
		</div>
  	<?php endif; ?>
</div>

<?php get_footer(); ?>
