<?php
/**
* The template for displaying all pages. *
* This is the template that displays all pages by default.
* Please note that this is the WordPress construct of pages
* and that other 'pages' on your WordPress site will use a
* different template. *
* @package intact
* by KeyDesign
*/
?>

<?php
  $page_headerimg_class = $section_style = '';

  $page_subtitle = get_post_meta( get_the_ID(), '_themetek_page_subtitle', true );
  $page_showhide_title = get_post_meta( get_the_ID(), '_themetek_page_showhide_title', true );
  $page_bgcolor = get_post_meta( get_the_ID(), '_themetek_page_bgcolor', true );
  $page_title_color = get_post_meta( get_the_ID(), '_themetek_page_title_color', true );
  $page_title_subtitle_color = 'color:'.$page_title_color.';';
  $page_layout = get_post_meta( get_the_ID(), '_themetek_page_layout', true );
  $page_overlay = get_post_meta( get_the_ID(), '_themetek_page_overlay', true );
  $page_top_padding = get_post_meta( get_the_ID(), '_themetek_page_top_padding', true );
  $page_bottom_padding = get_post_meta( get_the_ID(), '_themetek_page_bottom_padding', true );
  $header_image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full', false );

  if ( is_array( $header_image ) ) {
    if ( !$header_image[0] ) {
      $page_headerimg_class = "no-header-image";
    }
  }

  $css_classes = implode( ' ', array( 'section', $page_headerimg_class, $post->post_name ) );

  if ( '' !== $page_bgcolor ) {
    $section_style .= 'background-color:' .$page_bgcolor .';';
  }
  if ( '' !== $page_top_padding ) {
    $section_style .= 'padding-top:' . ( preg_match( '/(px|em|\%|pt|cm)$/', $page_top_padding ) ? $page_top_padding : $page_top_padding . 'px' ) . ';';
  }
  if ( '' !== $page_bottom_padding ) {
    $section_style .= 'padding-bottom:' . ( preg_match( '/(px|em|\%|pt|cm)$/', $page_bottom_padding ) ? $page_bottom_padding : $page_bottom_padding . 'px' ) . ';';
  }

  get_header();
?>

  <section id="single-page" class="<?php echo esc_attr( trim( $css_classes ) ); ?>" <?php echo ('' !== $section_style) ? 'style="'. esc_attr($section_style).'"' : ''; ?>>
   <?php if ( empty( $page_showhide_title ) ) { ?>
   <div class="row single-page-heading <?php echo ( ! empty( $page_overlay ) ? 'with-overlay' : '' );?>">
     <?php if ( '' != $header_image && is_array( $header_image ) ) : ?>
       <div class="header-overlay parallax-overlay" style="background-image:url('<?php echo esc_url( $header_image[0] ); ?>')"></div>
     <?php endif; ?>
     <div class="container <?php echo ( ! empty( $page_layout ) ? 'fullwidth' : '' );?>">
        <?php if ( empty( $page_showhide_title ) ) : ?>
          <h1 class="section-heading" <?php if ( ! empty( $page_title_color ) ) : ?> style="<?php echo esc_attr( $page_title_subtitle_color ); ?>"<?php endif; ?>><?php the_title(); ?></h1>
        <?php endif; ?>
        <?php if ( ! empty( $page_subtitle ) ) : ?>
          <span class="heading-separator" <?php if ( ! empty( $page_title_color ) ) : ?> style="background-color:<?php echo esc_attr( $page_title_color ); ?>;"<?php endif; ?>></span><p class="section-subheading" <?php if ( ! empty( $page_title_color ) ) : ?> style="<?php echo esc_attr( $page_title_subtitle_color ); ?>"<?php endif; ?>><?php echo esc_html( $page_subtitle ); ?></p>
        <?php endif; ?>
      </div>
    </div>
   <?php } ?>
   <div class="container <?php echo ( ! empty( $page_layout ) ? 'fullwidth' : '' ); ?>">
     <div class="row single-page-content">
       <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
         <?php the_content(); ?>
         <?php wp_link_pages(
           array(
             'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'intact' ),
             'after'  => '</div>',
           )
         ); ?>
         <?php
             if ( comments_open() || '0' != get_comments_number() ) { ?>
             <div class="page-content comments-content container">
               <?php comments_template(); ?>
             </div>
            <?php }
         ?>
       <?php endwhile; else: ?>
         <p><?php esc_html_e( 'Sorry, this page does not exist.', 'intact' ); ?></p>
       <?php endif; ?>
     </div>
   </div>
 </section>

<?php get_footer();?>
