<?php
/**
 * The Loop
 *
 * The Loop is PHP code used by WordPress to display posts.
 * Using The Loop, WordPress processes each post to be displayed
 * on the current page, and formats it according to how it matches
 * specified criteria within The Loop tags.
 * Learn more: https://codex.wordpress.org/The_Loop
 *
 * @package intact
 * by KeyDesign
 */
?>

<?php
	$parallax_class = $section_style = $css_classes = $wrapper_attributes = $page_overlay_class = '';

   $parallax_class = '';
   $parallax_src = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full', false, '' );
   $page_bgcolor = get_post_meta( get_the_ID(), '_themetek_page_bgcolor', true );
   $page_title_color = get_post_meta( get_the_ID(), '_themetek_page_title_color', true );
   $page_title_subtitle_color = ' color:'.$page_title_color.';';
   $page_overlay = get_post_meta( get_the_ID(), '_themetek_page_overlay', true );
   $page_layout = get_post_meta( get_the_ID(), '_themetek_page_layout', true );
   $page_showhide_title = get_post_meta( get_the_ID(), '_themetek_page_showhide_title', true );
   $page_subtitle = get_post_meta( get_the_ID(), '_themetek_page_subtitle', true );
   $page_top_padding = get_post_meta( get_the_ID(), '_themetek_page_top_padding', true );
   $page_bottom_padding = get_post_meta( get_the_ID(), '_themetek_page_bottom_padding', true );

   if ( ! empty( $parallax_src[0] ) && is_array( $parallax_src ) ) {
     $parallax_class = 'parallax';
   }

   if ( ! empty( $page_overlay ) ) {
     $page_overlay_class = 'with-overlay';
   }

   $css_classes = implode( ' ', array( 'section', $parallax_class, $page_overlay_class ) );

   if ( '' !== $page_bgcolor ) {
     $section_style .= 'background-color:' .$page_bgcolor .';';
   }
   if ( '' !== $page_top_padding ) {
     $section_style .= 'padding-top:' . ( preg_match( '/(px|em|\%|pt|cm)$/', $page_top_padding ) ? $page_top_padding : $page_top_padding . 'px' ) . ';';
   }
   if ( '' !== $page_bottom_padding ) {
     $section_style .= 'padding-bottom:' . ( preg_match( '/(px|em|\%|pt|cm)$/', $page_bottom_padding ) ? $page_bottom_padding : $page_bottom_padding . 'px' ) . ';';
   }
?>
<section id="<?php echo esc_attr( $post->post_name );?>" class="<?php echo esc_attr( trim( $css_classes ) ); ?>" <?php echo ('' !== $section_style) ? 'style="'. esc_attr($section_style).'"' : ''; ?>>
   <?php  if( ! empty( $parallax_src[0] ) && is_array( $parallax_src ) ) : ?>
     <div class="parallax-overlay" style="background-image:url('<?php echo esc_url($parallax_src[0]); ?>')"></div>
   <?php endif; ?>
   <div class="container <?php echo ( ! empty( $page_layout ) ? 'fullwidth' : '' ); ?>">
      <div class="row" >
		<?php if ( empty( $page_showhide_title ) ) : ?>
          <h2 class="section-heading" <?php if ( ! empty( $page_title_color ) ) : ?> style="<?php echo esc_attr( $page_title_subtitle_color ); ?>"<?php endif; ?>><?php the_title(); ?></h2>
        <?php endif; ?>
        <?php if ( ! empty( $page_subtitle ) ) : ?>
          <span class="heading-separator"></span><p class="section-subheading" <?php if ( ! empty( $page_title_color ) ) : ?> style="<?php echo esc_attr( $page_title_subtitle_color ); ?>"<?php endif; ?>><?php echo esc_html( $page_subtitle ); ?></p>
        <?php endif; ?>
      </div>
      <div class="row">
         <?php the_content(); ?>
      </div>
   </div>
</section>
