<?php
/**
 * Theme header
 * @package intact
 * by KeyDesign
 */
 ?>

<?php
  $menu_style = $menu_behaviour = $navbar_class = '';
  $favicon = intact_get_option( 'tek-favicon' );

  if ( intact_get_option( 'tek-menu-style' ) == '1' ) {
    $menu_style = 'fullwidth';
  }

  if ( intact_get_option( 'tek-menu-behaviour' ) == '2' ) {
    $menu_behaviour = 'fixed-menu';
  }

  $primary_logo = intact_get_option( 'tek-logo' );
  $secondary_logo = intact_get_option( 'tek-logo2' );
  $logo_size = intact_get_option( 'tek-logo-size' );

  $navbar_class = implode(' ', array('navbar', 'navbar-default', 'navbar-fixed-top', $menu_style, $menu_behaviour ) );
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
   <head>
      <meta charset="<?php bloginfo( 'charset' ); ?>">
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <link rel="profile" href="http://gmpg.org/xfn/11">

      <?php if ( isset( $favicon['url'] ) && '' != $favicon['url'] ) : ?>
        <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) : ?>
          <link href="<?php echo esc_url( $favicon['url'] ); ?>" rel="icon">
        <?php endif; ?>
      <?php endif; ?>

      <link rel="pingback" href="<?php esc_url(bloginfo( 'pingback_url' )); ?>" />
      <?php wp_head(); ?>
   </head>
    <body <?php body_class();?>>
		<!--script type="text/javascript">
var $zoho=$zoho || {};$zoho.salesiq = $zoho.salesiq ||
{widgetcode:"cd2e4d21b0963b16a9d8a8fda862c1fa1197978c479dfea3446305d7bfe74fbea109d801624d81c80f0a7b68195fd438a81d6b547a35c109951d24f6be71d2d0", values:{},ready:function(){}};
var d=document;s=d.createElement("script");s.type="text/javascript";s.id="zsiqscript";s.defer=true;
s.src="https://salesiq.zoho.in/widget";t=d.getElementsByTagName("script")[0];t.parentNode.insertBefore(s,t);d.write("<div id='zsiqwidget'></div>");
</script-->
      <?php wp_body_open(); ?>
      <?php if( intact_get_option( 'tek-preloader' ) ) : ?>
        <div id="preloader">
           <div class="spinner"></div>
        </div>
      <?php endif; ?>

      <?php if ( intact_get_option( 'tek-header-button' ) && intact_get_option( 'tek-header-button-action' ) == '1' ) {
          get_template_part( 'core/templates/header/content', 'contact-modal' );
        }
      ?>

      <nav class="<?php echo esc_attr( trim( $navbar_class ) ); ?>">
         <div class="container">
           <div id="logo">
             <?php if ( intact_get_option( 'tek-logo-style' ) == '1' ) : ?>
                 <a class="logo" href="<?php echo esc_url(home_url()); ?>">
                   <?php if ( isset( $primary_logo['url'] ) && '' != $primary_logo['url'] ) : ?>
                     <img class="fixed-logo" src="<?php echo esc_url( $primary_logo['url'] ); ?>" width="<?php echo esc_html( $logo_size['width'] );?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" />
                     <img class="nav-logo" src="<?php echo esc_url( $secondary_logo['url'] ); ?>" width="<?php echo esc_html( $logo_size['width'] );?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" />
                   <?php else: ?>
                     <img class="fixed-logo" src="<?php echo esc_url(get_template_directory_uri() . '/core/assets/images/logo.png'); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" />
                     <img class="nav-logo" src="<?php echo esc_url(get_template_directory_uri() . '/core/assets/images/logo-2.png'); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" />
                   <?php endif; ?>
                 </a>
               <?php elseif ( intact_get_option( 'tek-logo-style' ) == '2' ) : ?>
                 <a class="logo" href="<?php echo esc_url(site_url()); ?>"><?php echo esc_html( intact_get_option( 'tek-text-logo' ) );?></a>
             <?php endif; ?>
             <?php if ( ! class_exists( 'ReduxFramework' ) ) : ?>
                <a class="logo" href="<?php echo esc_url(site_url()); ?>"><?php bloginfo( 'name' ); ?></a>
             <?php endif; ?>
           </div>
           <div class="navbar-header page-scroll">
              <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#main-menu">
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
              </button>
              <?php if ( intact_get_option( 'tek-woo-cart' ) == '1' ) : ?>
                <div class="mobile-cart">
                    <?php
                      if( class_exists( 'WooCommerce' ) ) {
                          $keydesign_minicart = '';
                          $keydesign_minicart = keydesign_add_cart_in_menu();
                          echo do_shortcode( shortcode_unautop( $keydesign_minicart ) );
                      }
                    ?>
                </div>
              <?php endif; ?>
            </div>
            <div id="main-menu" class="collapse navbar-collapse  navbar-right">
               <?php
                  wp_nav_menu( array( 'theme_location' => 'keydesign-header-menu', 'depth' => 3, 'container' => false, 'menu_class' => 'nav navbar-nav', 'fallback_cb' => 'wp_bootstrap_navwalker::fallback', 'walker' => new wp_bootstrap_navwalker()) );
               ?>

               <?php if( intact_get_option( 'tek-search-bar' ) ) : ?>
                 <div class="header-search-bar">
                    <span class="toggle-search fa-search fa"></span>
                    <div class="header-search-container">
                      <?php get_search_form(); ?>
                    </div>
                 </div>
               <?php endif; ?>

               <?php if ( intact_get_option( 'tek-header-button' ) ) {
                      get_template_part( 'core/templates/header/content', 'header-button' );
                } ?>

              <?php
                if( class_exists( 'WooCommerce' ) && intact_get_option( 'tek-woo-cart' ) == '1' ) {
                    $keydesign_minicart = '';
                    $keydesign_minicart = keydesign_add_cart_in_menu();
                    echo do_shortcode( shortcode_unautop( $keydesign_minicart ) );
                }
              ?>

            </div>
         </div>
      </nav>

      <div id="wrapper" class="<?php if ( intact_get_option( 'tek-disable-animations' ) == true ) { echo 'no-mobile-animation'; } ?>" >
      <?php if(is_front_page()) { ?>
        <header id="header">
           <?php if ( intact_get_option( 'tek-slider' ) != '' ) : ?>
                 <div id="kd-slider" class="fullwidth">
                    <?php echo do_shortcode('[rev_slider alias="'. esc_attr( intact_get_option( 'tek-slider' ) ). '"]' ); ?>
                 </div>
           <?php endif; ?>
        </header>
      <?php } else if ( class_exists( 'WooCommerce' ) && is_woocommerce() && !is_product() ) { ?>
        <header id="header" class="shop-header">
        <?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
          <h1 class="section-heading"><?php woocommerce_page_title(); ?></h1>
          <?php do_action( 'woocommerce_archive_description' ); ?>
        <?php endif; ?>
        </header>
      <?php } else if ( !is_404() && !is_singular( 'themetek_portfolio' ) && !is_single() && !is_page() ) {
      $keydesign_header_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_option('page_for_posts')), 'full', false )  ?>
      <header id="header" class="blog-header">
          <?php if ( '' != $keydesign_header_image && is_array( $keydesign_header_image ) ) : ?>
            <div class="header-overlay parallax-overlay" style="background-image:url('<?php echo esc_url($keydesign_header_image[0]); ?>')"></div>
         <?php endif; ?>
         <div class="container">
            <div class="intro-text">
               <?php if ( is_category() ) { ?>
               <h2 class="section-heading"><?php echo apply_filters( 'kd_single_cat_title', esc_html__("Currently browsing:", "intact") ); ?> <?php single_cat_title(); ?></h2>
               <?php } elseif ( is_search() ) { ?>
               <h2 class="section-heading"><?php echo apply_filters( 'kd_search_query_title', esc_html__("Search results for:", "intact") ); ?> <?php the_search_query();  ?></h2>
               <?php } elseif ( is_tag() ) { ?>
               <h2 class="section-heading"><?php echo apply_filters( 'kd_single_tag_title', esc_html__("All posts tagged:", "intact") ); ?> <?php single_tag_title(); ?></h2>
               <?php } elseif ( is_author() ) { ?>
               <h2 class="section-heading"><?php echo apply_filters( 'kd_author_archive_title', esc_html__("All posts by", "intact") ); ?> <?php echo esc_attr(get_userdata(get_query_var('author'))->display_name); ?></h2>
               <?php } elseif ( is_day() ) { ?>
               <h2 class="section-heading"><?php echo apply_filters( 'kd_day_archive_title', esc_html__("Posts archive for", "intact") ); ?> <?php echo get_the_date('F jS, Y'); ?></h2>
               <?php } elseif ( is_month() ) { ?>
               <h2 class="section-heading"><?php echo apply_filters( 'kd_month_archive_title', esc_html__("Posts archive for", "intact") ); ?> <?php echo get_the_date('F, Y'); ?></h2>
               <?php } elseif ( is_year() ) { ?>
               <h2 class="section-heading"><?php echo apply_filters( 'kd_year_archive_title', esc_html__("Posts archive for", "intact") ); ?> <?php echo get_the_date('Y'); ?></h2>
               <?php } elseif ( is_front_page() && is_home() ) { ?>
               <h2 class="section-heading"><?php echo get_bloginfo( 'name' ); ?></h2>
               <?php } elseif ( get_page( get_option('page_for_posts') ) ) { ?>
               <h2 class="section-heading"><?php echo apply_filters('the_title',get_page( get_option('page_for_posts') )->post_title); ?></h2>
               <?php  } else { ?>
               <h1 class="section-heading"><?php echo esc_html(get_the_title(get_queried_object_id())); ?></h1>
               <?php  } ?>
               <span class="heading-separator"></span>
               <p class="section-subheading"><?php echo ( intact_get_option( 'tek-blog-subtitle' ) ) ? esc_attr( intact_get_option( 'tek-blog-subtitle' ) ) : ''; ?> </p>
            </div>
         </div>
      </header>
    <?php } ?>
