<?php
/**
 * Intact functions file
 *
 * @package intact
 * by KeyDesign
 */

 require_once( get_template_directory() . '/core/init.php');

 // -------------------------------------
 // Edit below this line
 // -------------------------------------
 
 /*
* Remove update notification for plugins...
*/

remove_action('load-update-core.php','wp_update_plugins');
add_filter('pre_site_transient_update_plugins','__return_null');

/*
* Remove update notifications for themes...
*/
function hide_update_notifications() {
	remove_action( 'admin_notices', 'update_nag', 3 );
}
add_action( 'admin_head', 'hide_update_notifications', 1 );

/** Disable automatic updates of theme and plugins */
add_filter( 'auto_update_plugin', '__return_false' );
add_filter( 'auto_update_theme', '__return_false' );

//* TN - Remove Query String from Static Resources
function remove_css_js_ver( $src ) {
	if( strpos( $src, '?ver=' ) ) {
		$src = remove_query_arg( 'ver', $src );
	}
	return $src;
}
add_filter( 'style_loader_src', 'remove_css_js_ver', 10, 2 );
add_filter( 'script_loader_src', 'remove_css_js_ver', 10, 2 );

function block_frames() {
    header('X-FRAME-OPTIONS: SAMEORIGIN');
}
add_action('send_headers', 'block_frames', 10);

header('Content-Security-Policy: default-src \'self\' \'unsafe-inline\' \'unsafe-eval\' https: data:');

header('X-XSS-Protection: 1; mode=block');
header('Cache-Control: max-age=31536000, private, no-cache, no-store, must-revalidate');


@ini_set('session.cookie_httponly', true);
@ini_set('session.cookie_secure', true);
@ini_set('session.use_only_cookies', true);