<?php
  /*
  * ReduxFramework Options Config
  */

  if ( ! class_exists( 'Redux' ) ) {
    return;
  }

  $opt_name = 'redux_ThemeTek';

  $theme = wp_get_theme();

  $args = array(
    'opt_name' => $opt_name,
    'display_name' => $theme->get( 'Name' ),
    'display_version' => $theme->get( 'Version' ),
    'menu_type' => 'submenu',
    'allow_sub_menu' => true,
    'menu_title' => esc_html__( 'Theme Options', 'intact' ),
    'page_title' => esc_html__( 'Theme Options', 'intact' ),
    'async_typography' => true,
    'admin_bar' => true,
    'dev_mode' => false,
    'update_notice' => false,
    'show_options_object' => false,
    'customizer' => false,
    'page_parent' => 'intact-dashboard',
    'page_slug' => 'theme-options',
    'page_permissions' => 'manage_options',
    'save_defaults' => true,
    'show_import_export' => true,
    'network_sites' => '1',
    'transient_time' => 60 * MINUTE_IN_SECONDS,
  );

  Redux::setArgs( $opt_name, $args );

  Redux::setSection( $opt_name, array(
      'icon' => 'el-icon-globe',
      'title' => esc_html__('Global Options', 'intact'),
      'compiler' => 'true',
      'fields' => array(
          array(
              'id' => 'tek-main-color',
              'type' => 'color',
              'transparent' => false,
              'title' => esc_html__('Main Theme Color', 'intact'),
              'default' => '#31d093',
              'validate' => 'color'
          ),
          array(
              'id' => 'tek-preloader',
              'type' => 'switch',
              'title' => esc_html__('Preloader', 'intact'),
              'subtitle' => esc_html__('Turn on/off theme preloader', 'intact'),
              'default' => true
          ),
          array(
              'id' => 'tek-smooth-scroll',
              'type' => 'switch',
              'title' => esc_html__('Smooth Scroll', 'intact'),
              'subtitle' => esc_html__('Turn on to replace basic website scrolling effect with nice smooth scroll.', 'intact'),
              'default' => false
          ),
          array(
              'id' => 'tek-google-api',
              'type' => 'text',
              'title' => __('Google Map API Key <a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank" class="el-icon-question-sign"></a>', 'intact'),
              'default' => '',
              'subtitle' => esc_html__('Generate, copy and paste here Google Maps API Key', 'intact'),
          ),
          array(
              'id' => 'tek-disable-animations',
              'type' => 'switch',
              'title' => esc_html__('Disable Animations on Mobile', 'intact'),
              'subtitle' => esc_html__('Globally turn on/off element animations on mobile', 'intact'),
              'default' => false
          ),
      )
  ) );

  Redux::setSection( $opt_name, array(
      'icon' => 'el-icon-star',
      'title' => esc_html__('Logo', 'intact'),
      'fields' => array(
        array(
            'id' => 'tek-logo-style',
            'type' => 'select',
            'title' => esc_html__('Logo Style', 'intact'),
            'select2' => array('allowClear' => false, 'minimumResultsForSearch' => '-1'),
            'options'  => array(
                '1' => 'Image logo',
                '2' => 'Text logo'
            ),
            'default' => '2'
        ),
        array(
            'id' => 'tek-logo',
            'type' => 'media',
            'readonly' => false,
            'url' => true,
            'title' => esc_html__('Logo Image', 'intact'),
            'subtitle' => esc_html__('Upload logo image', 'intact'),
            'required' => array('tek-logo-style','equals','1'),
            'default' => array(
                'url' => get_template_directory_uri() . '/core/assets/images/logo.png'
            )
        ),
        array(
            'id' => 'tek-logo2',
            'type' => 'media',
            'readonly' => false,
            'url' => true,
            'title' => esc_html__('Secondary Logo Image', 'intact'),
            'subtitle' => esc_html__('Upload logo image for sticky navigation', 'intact'),
            'required' => array('tek-logo-style','equals','1'),
            'default' => array(
                'url' => get_template_directory_uri() . '/core/assets/images/logo-2.png'
            )
        ),
        array(
            'id' => 'tek-logo-size',
            'type' => 'dimensions',
            'height' => false,
            'units' => false,
            'url' => true,
            'title' => esc_html__('Logo Size', 'intact'),
            'subtitle' => esc_html__('Choose logo width. Pixel value.', 'intact'),
            'required' => array('tek-logo-style','equals','1'),
        ),
        array(
            'id' => 'tek-text-logo',
            'type' => 'text',
            'title' => esc_html__('Logo Text', 'intact'),
            'required' => array('tek-logo-style','equals','2'),
            'default' => 'Intact'
        ),
        array(
            'id' => 'tek-main-logo-color',
            'type' => 'color',
            'transparent' => false,
            'title' => esc_html__('Main Logo Text Color', 'intact'),
            'required' => array('tek-logo-style','equals','2'),
            'default' => '#1f1f1f',
            'validate' => 'color'
        ),
        array(
            'id' => 'tek-secondary-logo-color',
            'type' => 'color',
            'transparent' => false,
            'title' => esc_html__('Secondary Logo Text Color', 'intact'),
            'subtitle' => esc_html__('Logo text color for sticky navigation', 'intact'),
            'required' => array('tek-logo-style','equals','2'),
            'default' => '#1f1f1f',
            'validate' => 'color'
        ),
        array(
            'id' => 'tek-favicon',
            'type' => 'media',
            'readonly' => false,
            'preview' => false,
            'url' => true,
            'title' => esc_html__('Favicon', 'intact'),
            'subtitle' => esc_html__('Upload favicon image', 'intact'),
            'default' => array(
                'url' => get_template_directory_uri() . '/core/assets/images/favicon.png'
            )
        ),
      )
  ) );

  Redux::setSection( $opt_name, array(
      'icon' => 'el-icon-lines',
      'title' => esc_html__('Header', 'intact'),
      'compiler' => 'true',
      'fields' => array(
          array(
              'id'=>'tek-header-bar-section-start',
              'type' => 'section',
              'title' => esc_html__('Header Bar Settings', 'intact'),
              'indent' => true,
          ),
          array(
              'id' => 'tek-menu-style',
              'type' => 'button_set',
              'title' => esc_html__('Header Bar Width', 'intact'),
              'subtitle' => esc_html__('You can choose between full width and contained.', 'intact'),
              'options' => array(
                  '1' => 'Full width',
                  '2' => 'Contained'
               ),
              'default' => '1'
          ),
          array(
              'id' => 'tek-menu-behaviour',
              'type' => 'button_set',
              'title' => esc_html__('Header Bar Behaviour', 'intact'),
              'subtitle' => esc_html__('You can choose between a sticky or a fixed top menu.', 'intact'),
              'options' => array(
                  '1' => 'Sticky',
                  '2' => 'Fixed'
               ),
              'default' => '1'
          ),
          array(
              'id' => 'tek-search-bar',
              'type' => 'switch',
              'title' => esc_html__('Search Bar', 'intact'),
              'subtitle' => esc_html__('Turn on to display search bar.', 'intact'),
              'default' => false
          ),
          array(
              'id' => 'tek-header-menu-bg',
              'type' => 'color',
              'title' => esc_html__('Header Bar Background Color', 'intact'),
              'default' => '',
              'validate' => 'color'
          ),
          array(
              'id' => 'tek-header-menu-bg-sticky',
              'type' => 'color',
              'transparent' => false,
              'title' => esc_html__('Sticky Header Bar Background Color', 'intact'),
              'default' => '',
              'validate' => 'color'
          ),
          array(
            	'id'=>'tek-header-bar-section-end',
            	'type' => 'section',
            	'indent' => false,
          ),
          array(
            	'id'=>'tek-menu-settings-section-start',
            	'type' => 'section',
            	'title' => esc_html__('Main Menu Settings', 'intact'),
            	'indent' => true,
          ),
          array(
              'id' => 'tek-menu-typo',
              'type' => 'typography',
              'title' => esc_html__('Menu Font Settings', 'intact'),
              'google' => true,
              'font-style' => true,
              'font-size' => true,
              'line-height' => false,
              'text-transform' => true,
              'color' => false,
              'text-align' => false,
              'preview' => true,
              'all_styles' => false,
              'units' => 'px',
              'preview' => array(
                  'text' => 'Menu Item'
              )
          ),
          array(
              'id' => 'tek-header-menu-color',
              'type' => 'color',
              'transparent' => false,
              'title' => esc_html__('Menu Link Color', 'intact'),
              'default' => '',
              'validate' => 'color'
          ),
          array(
              'id' => 'tek-header-menu-color-hover',
              'type' => 'color',
              'transparent' => false,
              'title' => esc_html__('Menu Link Hover Color', 'intact'),
              'default' => '',
              'validate' => 'color'
          ),
          array(
              'id' => 'tek-header-menu-color-sticky',
              'type' => 'color',
              'transparent' => false,
              'title' => esc_html__('Sticky Menu Link Color', 'intact'),
              'default' => '',
              'validate' => 'color'
          ),
          array(
              'id' => 'tek-header-menu-color-sticky-hover',
              'type' => 'color',
              'transparent' => false,
              'title' => esc_html__('Sticky Menu Link Hover Color', 'intact'),
              'default' => '',
              'validate' => 'color'
          ),
          array(
            	'id'=>'tek-menu-settings-section-end',
            	'type' => 'section',
            	'indent' => false,
          ),
      )
  ) );

  Redux::setSection( $opt_name, array(
      'title' => esc_html__('Header Button', 'intact'),
      'subsection' => true,
      'fields' => array(
        array(
            'id' => 'tek-header-button',
            'type' => 'switch',
            'title' => esc_html__('Enable Header Button', 'intact'),
            'default' => false
        ),
        array(
            'id' => 'tek-header-button-text',
            'type' => 'text',
            'title' => esc_html__('Button Text', 'intact'),
            'required' => array('tek-header-button','equals', true),
            'default' => 'Let`s Talk'
        ),
        array(
            'id' => 'tek-header-button-action',
            'type' => 'select',
            'title' => esc_html__('Button Action', 'intact'),
            'required' => array('tek-header-button','equals', true),
            'select2' => array('allowClear' => false, 'minimumResultsForSearch' => '-1'),
            'options'  => array(
                '1' => 'Open modal window with contact form',
                '2' => 'Scroll to section',
                '3' => 'Open a new page'
            ),
            'default' => '3'
        ),
        array(
            'id' => 'tek-modal-title',
            'type' => 'text',
            'title' => esc_html__('Modal Title', 'intact'),
            'required' => array('tek-header-button-action','equals','1'),
            'default' => 'Just ask. Get answers.'
        ),
        array(
            'id' => 'tek-modal-subtitle',
            'type' => 'text',
            'title' => esc_html__('Modal Subtitle', 'intact'),
            'required' => array('tek-header-button-action','equals','1'),
            'default' => 'Your questions and comments are important to us.'
        ),
        array(
            'id' => 'tek-modal-form-select',
            'type' => 'select',
            'title' => esc_html__('Contact Form Plugin', 'intact'),
            'required' => array('tek-header-button-action','equals','1'),
            'select2' => array('allowClear' => false, 'minimumResultsForSearch' => '-1'),
            'options'  => array(
                '1' => 'Contact Form 7',
                '2' => 'Ninja Forms',
                '3' => 'Gravity Forms',
                '4' => 'WP Forms',
            ),
            'default' => '1'
        ),
        array(
            'id' => 'tek-modal-contactf7-formid',
            'type' => 'select',
            'data' => 'posts',
            'args' => array( 'post_type' => 'wpcf7_contact_form', ),
            'title' => esc_html__('Contact Form 7 Title', 'intact'),
            'required' => array('tek-modal-form-select','equals','1'),
            'default' => ''
        ),
        array(
            'id' => 'tek-modal-ninja-formid',
            'type' => 'text',
            'title' => esc_html__('Ninja Form ID', 'intact'),
            'required' => array('tek-modal-form-select','equals','2'),
            'default' => ''
        ),
        array(
            'id' => 'tek-modal-gravity-formid',
            'type' => 'text',
            'title' => esc_html__('Gravity Form ID', 'intact'),
            'required' => array('tek-modal-form-select','equals','3'),
            'default' => ''
        ),
        array(
            'id' => 'tek-modal-wp-formid',
            'type' => 'text',
            'title' => esc_html__('WP Form ID', 'intact'),
            'required' => array('tek-modal-form-select','equals','4'),
            'default' => ''
        ),
        array(
            'id' => 'tek-scroll-id',
            'type' => 'text',
            'title' => esc_html__('Scroll to section ID', 'intact'),
            'required' => array('tek-header-button-action','equals','2'),
            'default' => '#download-intact'
        ),
        array(
            'id' => 'tek-button-new-page',
            'type' => 'text',
            'title' => esc_html__('Button Link', 'intact'),
            'required' => array('tek-header-button-action','equals','3'),
            'default' => '#'
        ),
        array(
            'id' => 'tek-button-target',
            'type' => 'select',
            'title' => esc_html__('Link Target', 'intact'),
            'required' => array('tek-header-button-action','equals','3'),
            'select2' => array('allowClear' => false, 'minimumResultsForSearch' => '-1'),
            'options'  => array(
                'new-page' => 'Open in a new page',
                'same-page' => 'Open in same page'
            ),
            'default' => 'new-page'
        ),
      )
  ) );

  Redux::setSection( $opt_name, array(
      'icon' => 'el-icon-website',
      'title' => esc_html__('Home Slider', 'intact'),
      'compiler' => 'true',
      'fields' => array(
          array(
              'id' => 'tek-slider',
              'type' => 'text',
              'title' => esc_html__('Revolution Slider Alias Name', 'intact'),
              'subtitle' => esc_html__('Enter Revolution Slider alias name here.', 'intact'),
              'default' => ''
          )
      )
  ) );

  Redux::setSection( $opt_name, array(
      'icon' => 'el-icon-thumbs-up',
      'title' => esc_html__('Footer', 'intact'),
      'fields' => array(

          array(
              'id' => 'tek-footer-fixed',
              'type' => 'switch',
              'title' => esc_html__('Fixed Footer', 'intact'),
              'subtitle' => esc_html__('Turn on/off this feature', 'intact'),
              'default' => true
          ),
          array(
              'id' => 'tek-backtotop',
              'type' => 'switch',
              'title' => esc_html__('Enable Go to Top Button', 'intact'),
              'subtitle' => esc_html__('Enable to display the Go to Top button.', 'intact'),
              'default' => true
          ),
          array(
              'id' => 'tek-upper-footer-color',
              'type' => 'color',
              'transparent' => false,
              'title' => esc_html__('Upper Footer Background', 'intact'),
              'default' => '#1f1f1f',
              'validate' => 'color'
          ),
          array(
              'id' => 'tek-lower-footer-color',
              'type' => 'color',
              'transparent' => false,
              'title' => esc_html__('Lower Footer Background', 'intact'),
              'default' => '#1f1f1f',
              'validate' => 'color'
          ),
          array(
              'id' => 'tek-footer-heading-color',
              'type' => 'color',
              'transparent' => false,
              'title' => esc_html__('Footer Headings Color', 'intact'),
              'default' => '#ffffff',
              'validate' => 'color'
          ),
          array(
              'id' => 'tek-footer-text-color',
              'type' => 'color',
              'transparent' => false,
              'title' => esc_html__('Footer Text Color', 'intact'),
              'default' => '#e8e8e8',
              'validate' => 'color'
          ),
          array(
              'id' => 'tek-footer-text',
              'type' => 'editor',
              'title' => esc_html__('Copyright Text', 'intact'),
              'subtitle' => esc_html__('Enter footer bottom copyright text', 'intact'),
              'default' => 'Intact by KeyDesign. All rights reserved.',
              'args' => array(
                  'teeny' => true,
                  'textarea_rows' => 3,
                  'media_buttons' => false,
              ),
          ),
          array(
              'id' => 'tek-social-icons',
              'type' => 'checkbox',
              'title' => esc_html__('Social Icons', 'intact'),
              'subtitle' => esc_html__('Select visible social icons', 'intact'),
              'options' => array(
                  '1' => 'Facebook',
                  '2' => 'Twitter',
                  '3' => 'Google+',
                  '4' => 'Pinterest',
                  '5' => 'Youtube',
                  '6' => 'Linkedin',
                  '7' => 'Instagram'
              ),
              'default' => array(
                  '1' => '1',
                  '2' => '1',
                  '3' => '1',
                  '4' => '0',
                  '5' => '0',
                  '6' => '1',
                  '7' => '0',
              )
          ),
          array(
              'id' => 'tek-facebook-url',
              'type' => 'text',
              'title' => esc_html__('Facebook Link', 'intact'),
              'subtitle' => esc_html__('Enter Facebook URL', 'intact'),
              'validate' => 'url',
              'default' => 'http://www.facebook.com/'
          ),

          array(
              'id' => 'tek-twitter-url',
              'type' => 'text',
              'title' => esc_html__('Twitter Link', 'intact'),
              'subtitle' => esc_html__('Enter Twitter URL', 'intact'),
              'validate' => 'url',
              'default' => 'http://www.twitter.com/'
          ),

          array(
              'id' => 'tek-google-url',
              'type' => 'text',
              'title' => esc_html__('Google+ Link', 'intact'),
              'subtitle' => esc_html__('Enter Google+ URL', 'intact'),
              'default' => 'http://plus.google.com/'
          ),
          array(
              'id' => 'tek-pinterest-url',
              'type' => 'text',
              'title' => esc_html__('Pinterest Link', 'intact'),
              'subtitle' => esc_html__('Enter Pinterest URL', 'intact'),
              'validate' => 'url',
              'default' => 'http://www.pinterest.com/'
          ),

          array(
              'id' => 'tek-youtube-url',
              'type' => 'text',
              'title' => esc_html__('Youtube Link', 'intact'),
              'subtitle' => esc_html__('Enter Youtube URL', 'intact'),
              'validate' => 'url',
              'default' => 'http://www.youtube.com/'
          ),
          array(
              'id' => 'tek-linkedin-url',
              'type' => 'text',
              'title' => esc_html__('Linkedin Link', 'intact'),
              'subtitle' => esc_html__('Enter Linkedin URL', 'intact'),
              'validate' => 'url',
              'default' => 'http://www.linkedin.com/'
          ),
          array(
              'id' => 'tek-instagram-url',
              'type' => 'text',
              'title' => esc_html__('Instagram Link', 'intact'),
              'subtitle' => esc_html__('Enter Instagram URL', 'intact'),
              'validate' => 'url',
              'default' => 'http://www.instagram.com/'
          ),

      )
  ) );

  Redux::setSection( $opt_name, array(
      'icon' => 'el-icon-fontsize',
      'title' => esc_html__('Typography', 'intact'),
      'compiler' => true,
      'fields' => array(
          array(
              'id' => 'tek-default-typo',
              'type' => 'typography',
              'title' => esc_html__('Body Typography', 'intact'),
              'google' => true,
              'font-style' => true,
              'font-size' => true,
              'line-height' => true,
              'color' => true,
              'text-align' => true,
              'preview' => true,
              'all_styles' => true,
              'units' => 'px',
              'default' => array(
                  'color' => '#666',
                  'font-weight' => '300',
                  'font-family' => 'Open Sans',
                  'google' => true,
                  'font-size' => '14px',
                  'text-align' => 'left',
                  'line-height' => '24px'
              ),
              'preview' => array(
                  'text' => 'Sample Text'
              )
          ),
          array(
              'id' => 'tek-heading-typo',
              'type' => 'typography',
              'title' => esc_html__('Heading Typography', 'intact'),
              'google' => true,
              'font-style' => true,
              'font-size' => true,
              'line-height' => true,
              'color' => true,
              'text-align' => true,
              'preview' => true,
              'all_styles' => true,
              'units' => 'px',
              'default' => array(
                  'color' => '#1f1f1f',
                  'font-weight' => '700',
                  'font-family' => 'Poppins',
                  'google' => true,
                  'font-size' => '34px',
                  'text-align' => 'center',
                  'line-height' => '45px'
              ),
              'preview' => array(
                  'text' => 'Intact Sample Text'
              )
          ),
      )
  ) );

  Redux::setSection( $opt_name, array(
      'title' => esc_html__('Typekit Fonts', 'intact'),
      'subsection' => true,
      'fields' => array(
        array(
            'id' => 'tek-typekit-switch',
            'type' => 'switch',
            'title' => esc_html__('Enable Typekit', 'intact'),
            'subtitle' => esc_html__('Select to enable Typekit fonts and display options below.', 'intact'),
            'default' => true
        ),
        array(
            'id' => 'tek-typekit',
            'type' => 'text',
            'title' => __('Typekit ID <a href="http://keydesign-themes.com/intact/documentation#ops-typekit" target="_blank" class="el-icon-question-sign"></a>', 'intact'),
            'subtitle' => esc_html__('Enter in the ID for your kit here. Only published data is accessible, so make sure that any changes you make to your kit are updated.', 'intact'),
            'mode' => 'text',
            'default' => '',
            'theme' => 'chrome',
            'required' => array('tek-typekit-switch','equals', true),
        ),
        array(
            'id' => 'tek-body-typekit-selector',
            'type' => 'text',
            'title' => __('Body Font Selector <a href="https://helpx.adobe.com/typekit/using/css-selectors.html" target="_blank" class="el-icon-question-sign"></a>', 'intact'),
            'subtitle' => esc_html__('Add the Typekit font family name.', 'intact'),
            'default' => '',
            'required' => array('tek-typekit-switch','equals', true),
        ),
        array(
            'id' => 'tek-heading-typekit-selector',
            'type' => 'text',
            'title' => __('Headings Font Selector <a href="https://helpx.adobe.com/typekit/using/css-selectors.html" target="_blank" class="el-icon-question-sign"></a>', 'intact'),
            'subtitle' => esc_html__('Add the Typekit font family name.', 'intact'),
            'default' => '',
            'required' => array('tek-typekit-switch','equals', true),
        ),
      )
  ) );

  Redux::setSection( $opt_name, array(
      'icon' => 'el-icon-th-list',
      'title' => esc_html__('Portfolio', 'intact'),
      'compiler' => 'true',
      'fields' => array(
          array(
      				'id' =>	'tek-portfolio-title',
      				'type' => 'switch',
      				'title' => esc_html__('Show title', 'intact'),
      				'subtitle' => esc_html__('Activate to display the portfolio item title in the content area.', 'intact'),
      				'default' => '1',
      				'on' => 'Yes',
      				'off' => 'No',
    			),
          array(
      				'id' =>	'tek-portfolio-meta',
      				'type' => 'switch',
      				'title' => esc_html__('Meta section', 'intact'),
      				'subtitle' => esc_html__('Activate to display the meta section (Category, Tags, Publish Date).', 'intact'),
      				'default' => '1',
      				'on' => 'Yes',
      				'off' => 'No',
    			),
          array(
      				'id' =>	'tek-portfolio-social',
      				'type' => 'switch',
      				'title' => esc_html__('Social media section', 'intact'),
      				'subtitle' => esc_html__('Activate to display the share on social media buttons.', 'intact'),
      				'default' => '1',
      				'on' => 'Yes',
      				'off' => 'No',
    			),
          array(
              'id' => 'tek-portfolio-bgcolor',
              'type' => 'color',
              'transparent' => false,
              'title' => esc_html__('Page background color', 'intact'),
              'subtitle' => esc_html__('Select the background color for the content area.', 'intact'),
              'default' => '#fafafa',
              'validate' => 'color'
          ),
      )
  ) );

  Redux::setSection( $opt_name, array(
      'icon' => 'el-icon-shopping-cart',
      'title' => esc_html__('WooCommerce', 'intact'),
      'compiler' => 'true',
      'fields' => array(
          array(
              'id' => 'tek-woo-products-number',
              'type' => 'text',
              'title' => __('Products per Page', 'intact'),
              'subtitle' => esc_html__('Change the products number listed per page.', 'intact'),
              'default' => '9',
          ),
          array(
              'id' => 'tek-woo-sidebar-position',
              'type' => 'select',
              'title' => esc_html__('Shop Sidebar Position', 'intact'),
              'select2' => array('allowClear' => false, 'minimumResultsForSearch' => '-1'),
              'options'  => array(
                  'woo-sidebar-left' => 'Left',
                  'woo-sidebar-right' => 'Right',
              ),
              'default' => 'woo-sidebar-right'
          ),
          array(
              'id' => 'tek-woo-single-sidebar',
              'type' => 'switch',
              'title' => esc_html__('Single Product Sidebar', 'intact'),
              'subtitle' => esc_html__('Enable/disable shop sidebar on single product page.', 'intact'),
              'default' => '0',
              '1' => 'Yes',
              '0' => 'No',
          ),
          array(
              'id' => 'tek-woo-cart',
              'type' => 'switch',
              'title' => esc_html__('Cart Icon', 'intact'),
              'subtitle' => esc_html__('Turn on to display shopping cart icon in header.', 'intact'),
              'default' => '1',
              '1' => 'On',
              '0' => 'Off',
          ),
      )
  ) );

  Redux::setSection( $opt_name, array(
      'icon' => 'el-icon-pencil-alt',
      'title' => esc_html__('Blog', 'intact'),
      'fields' => array(
          array(
              'id' => 'tek-blog-subtitle',
              'type' => 'text',
              'title' => esc_html__('Blog Subtitle', 'intact'),
              'default' => 'Welcome to Intact. This is your first post. Edit or delete it, then start blogging!'
              //
          ),
          array(
              'id' => 'tek-blog-sidebar',
              'type' => 'switch',
              'title' => esc_html__('Display Sidebar', 'intact'),
              'subtitle' => esc_html__('Turn on/off blog sidebar', 'intact'),
              'default' => true
          ),
          array(
              'id' => 'tek-blog-minimal',
              'type' => 'switch',
              'title' => esc_html__('Minimal Blog', 'intact'),
              'subtitle' => esc_html__('Change blog layout to minimal style', 'intact'),
              'default' => false
          )
      )
  ) );

  Redux::setSection( $opt_name, array(
      'icon' => 'el-icon-error-alt',
      'title' => esc_html__('404 Page', 'intact'),
      'fields' => array(
          array(
              'id' => 'tek-404-title',
              'type' => 'text',
              'title' => esc_html__('Title', 'intact'),
              'default' => 'Error 404',
          ),
          array(
              'id' => 'tek-404-subtitle',
              'type' => 'text',
              'title' => esc_html__('Subtitle', 'intact'),
              'default' => 'This page could not be found!',
          ),
          array(
              'id' => 'tek-404-back',
              'type' => 'text',
              'title' => esc_html__('Back to Homepage Text', 'intact'),
              'default' => 'Back to homepage',
          ),
      )
  ) );

  Redux::setSection( $opt_name, array(
      'icon' => 'el-icon-wrench-alt',
      'title' => esc_html__('Maintenance Page', 'intact'),
      'fields' => array(
          array(
              'id' => 'tek-maintenance-mode',
              'type' => 'switch',
              'title' => __('Enable Maintenance Mode', 'intact'),
              'subtitle' => esc_html__('Activate to enable maintenance mode.', 'intact'),
              'default' => false
          ),
          array(
              'id' => 'tek-maintenance-title',
              'type' => 'text',
              'title' => esc_html__('Page Title', 'intact'),
              'required' => array('tek-maintenance-mode','equals', true),
              'default' => 'StartUp launching soon'
          ),
          array(
              'id' => 'tek-maintenance-content',
              'type' => 'editor',
              'title' => esc_html__('Page Content', 'intact'),
              'required' => array('tek-maintenance-mode','equals', true),
              'default' => '',
              'args'   => array(
                'teeny'  => true,
                'textarea_rows' => 10,
                'media_buttons' => false,
              )
          ),
          array(
              'id' => 'tek-maintenance-countdown',
              'type' => 'switch',
              'title' => __('Enable Countdown', 'intact'),
              'subtitle' => esc_html__('Activate to enable the countdown timer.', 'intact'),
              'required' => array('tek-maintenance-mode','equals', true),
              'default' => false
          ),
          array(
              'id' => 'tek-maintenance-count-day',
              'type' => 'text',
              'title' => esc_html__('End Day', 'intact'),
              'subtitle' => esc_html__('Enter day value. Eg. 05', 'intact'),
              'required' => array('tek-maintenance-countdown','equals', true),
              'default' => ''
          ),
          array(
              'id' => 'tek-maintenance-count-month',
              'type' => 'text',
              'title' => esc_html__('End Month', 'intact'),
              'subtitle' => esc_html__('Enter month value. Eg. 09', 'intact'),
              'required' => array('tek-maintenance-countdown','equals', true),
              'default' => ''
          ),
          array(
              'id' => 'tek-maintenance-count-year',
              'type' => 'text',
              'title' => esc_html__('End Year', 'intact'),
              'subtitle' => esc_html__('Enter year value. Eg. 2020', 'intact'),
              'required' => array('tek-maintenance-countdown','equals', true),
              'default' => ''
          ),
          array(
              'id' => 'tek-maintenance-days-text',
              'type' => 'text',
              'title' => esc_html__('Days Label', 'intact'),
              'subtitle' => esc_html__('Enter days text label.', 'intact'),
              'required' => array('tek-maintenance-countdown','equals', true),
              'default' => 'Days'
          ),
          array(
              'id' => 'tek-maintenance-hours-text',
              'type' => 'text',
              'title' => esc_html__('Hours Label', 'intact'),
              'subtitle' => esc_html__('Enter hours text label.', 'intact'),
              'required' => array('tek-maintenance-countdown','equals', true),
              'default' => 'Hours'
          ),
          array(
              'id' => 'tek-maintenance-minutes-text',
              'type' => 'text',
              'title' => esc_html__('Minutes Label', 'intact'),
              'subtitle' => esc_html__('Enter minutes text label.', 'intact'),
              'required' => array('tek-maintenance-countdown','equals', true),
              'default' => 'Minutes'
          ),
          array(
              'id' => 'tek-maintenance-seconds-text',
              'type' => 'text',
              'title' => esc_html__('Seconds Label', 'intact'),
              'subtitle' => esc_html__('Enter seconds text label.', 'intact'),
              'required' => array('tek-maintenance-countdown','equals', true),
              'default' => 'Seconds'
          ),
          array(
              'id' => 'tek-maintenance-subscribe',
              'type' => 'switch',
              'title' => __('Enable Contact Form', 'intact'),
              'subtitle' => esc_html__('Activate to enable contact form on page.', 'intact'),
              'required' => array('tek-maintenance-mode','equals', true),
              'default' => false
          ),
          array(
              'id' => 'tek-maintenance-form-select',
              'type' => 'select',
              'title' => esc_html__('Contact Form Plugin', 'intact'),
              'required' => array('tek-maintenance-subscribe','equals',true),
              'select2' => array('allowClear' => false, 'minimumResultsForSearch' => '-1'),
              'options'  => array(
                  '1' => 'Contact Form 7',
                  '2' => 'Ninja Forms',
                  '3' => 'Gravity Forms',
                  '4' => 'WP Forms',
              ),
              'default' => '1'
          ),
          array(
              'id' => 'tek-maintenance-contactf7-formid',
              'type' => 'select',
              'data' => 'posts',
              'args' => array( 'post_type' => 'wpcf7_contact_form', 'posts_per_page' => -1, ),
              'title' => esc_html__('Contact Form 7 Title', 'intact'),
              'required' => array('tek-maintenance-form-select','equals','1'),
              'default' => ''
          ),
          array(
              'id' => 'tek-maintenance-ninja-formid',
              'type' => 'text',
              'title' => esc_html__('Ninja Form ID', 'intact'),
              'required' => array('tek-maintenance-form-select','equals','2'),
              'default' => ''
          ),
          array(
              'id' => 'tek-maintenance-gravity-formid',
              'type' => 'text',
              'title' => esc_html__('Gravity Form ID', 'intact'),
              'required' => array('tek-maintenance-form-select','equals','3'),
              'default' => ''
          ),
          array(
              'id' => 'tek-maintenance-wp-formid',
              'type' => 'text',
              'title' => esc_html__('WP Form ID', 'intact'),
              'required' => array('tek-maintenance-form-select','equals','4'),
              'default' => ''
          ),

      )
  ) );

  Redux::setSection( $opt_name, array(
      'icon' => 'el-icon-css',
      'title' => esc_html__('Custom CSS/JS', 'intact'),
      'fields' => array(
          array(
              'id' => 'tek-css',
              'type' => 'ace_editor',
              'title' => esc_html__('CSS', 'intact'),
              'subtitle' => esc_html__('Enter your CSS code in the side field. Do not include any tags or HTML in the field. Custom CSS entered here will override the theme CSS.', 'intact'),
              'mode' => 'css',
              'theme' => 'chrome',
          ),
          array(
        			'id' => 'tek-javascript',
        			'type' => 'ace_editor',
        			'title' => esc_html__( 'Javascript', 'intact' ),
        			'subtitle' => esc_html__( 'Only accepts Javascript code.', 'intact' ),
        			'mode' => 'html',
        			'theme' => 'chrome',
      		),
      )
  ) );
