<?php

// ------------------------------------------------------------------------
// Define Constants
// ------------------------------------------------------------------------

	define( 'INTACT_THEME_VERSION', '2.7' );
	define( 'INTACT_THEME_DIR', trailingslashit( get_template_directory() ) );
	define( 'INTACT_THEME_URI', trailingslashit( esc_url( get_template_directory_uri() ) ) );

// ------------------------------------------------------------------------
// Theme includes
// ------------------------------------------------------------------------

	require_once INTACT_THEME_DIR . 'core/assets/extra/class-tgm-plugin-activation.php';
	require_once INTACT_THEME_DIR . 'core/theme-activation.php';
	require_once INTACT_THEME_DIR . 'core/options-init.php';
	require_once INTACT_THEME_DIR . 'core/helper-functions.php';

	require_once INTACT_THEME_DIR . 'core/theme-sidebars.php';
	require_once INTACT_THEME_DIR . 'core/assets/extra/wp_bootstrap_navwalker.php';

	require_once INTACT_THEME_DIR . 'core/theme-woocommerce.php';

// ------------------------------------------------------------------------
// Enqueue scripts and styles front and admin
// ------------------------------------------------------------------------

	if( ! function_exists( 'intact_enqueue_scripts' ) ) {
		function intact_enqueue_scripts() {
			// Bootstrap CSS
			wp_register_style( 'bootstrap', INTACT_THEME_URI . 'core/assets/css/bootstrap.min.css', '', INTACT_THEME_VERSION, 'all' );
			wp_enqueue_style( 'bootstrap' );
			// Theme main style CSS
			wp_register_style( 'keydesign-style', get_stylesheet_uri(), array( 'bootstrap' ), INTACT_THEME_VERSION, 'all' );
			wp_enqueue_style( 'keydesign-style' );

			// WooCommerce style
			if ( class_exists ( 'WooCommerce' ) ) {
				wp_register_style( 'woocommerce', INTACT_THEME_URI . 'core/assets/css/woocommerce.css', array( 'keydesign-style' ), INTACT_THEME_VERSION, 'all' );
				wp_enqueue_style( 'woocommerce' );
			}

			// Font Awesome
			wp_register_style( 'font-awesome', INTACT_THEME_URI . 'core/assets/css/font-awesome.min.css', '', INTACT_THEME_VERSION, 'all' );
			wp_enqueue_style( 'font-awesome' );

			// Bootstrap JS
			wp_register_script( 'bootstrapjs', INTACT_THEME_URI . 'core/assets/js/bootstrap.min.js', array('jquery'), INTACT_THEME_VERSION, true );
			wp_enqueue_script( 'bootstrapjs' );

			// Masonry
			if( is_front_page() || is_page_template('portfolio.php') ) {
				wp_enqueue_script( 'masonry' );
			}

			wp_register_style( 'photoswipe', INTACT_THEME_URI . 'core/assets/css/photoswipe.css', '', INTACT_THEME_VERSION, 'all' );
			wp_register_style( 'photoswipe-skin', INTACT_THEME_URI . 'core/assets/css/photoswipe-default-skin.css', '', INTACT_THEME_VERSION, 'all' );
			wp_register_script( 'photoswipejs', INTACT_THEME_URI . 'core/assets/js/photoswipe.min.js', array('jquery'), INTACT_THEME_VERSION, true );
			wp_register_script( 'photoswipejs-ui', INTACT_THEME_URI . 'core/assets/js/photoswipe-ui-default.min.js', array('jquery'), INTACT_THEME_VERSION, true );

			wp_enqueue_style( 'photoswipe' );
			wp_enqueue_style( 'photoswipe-skin' );
			wp_enqueue_script( 'photoswipejs' );
			wp_enqueue_script( 'photoswipejs-ui' );

			// Smooth scroll
			wp_register_script( 'intact-smooth-scroll', INTACT_THEME_URI . 'core/assets/js/SmoothScroll.js', array('jquery'), INTACT_THEME_VERSION, true );
			if ( intact_get_option( 'tek-smooth-scroll' ) != false ) {
				wp_enqueue_script( 'intact-smooth-scroll' );
			}

			// Theme main scripts
			wp_register_script( 'intact-scripts', INTACT_THEME_URI . 'core/assets/js/scripts.js', array('jquery'), INTACT_THEME_VERSION, true );
			wp_enqueue_script( 'intact-scripts' );

			// Comment reply script
			if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
				wp_enqueue_script( 'comment-reply' );
			}

			// Inline styles
			add_filter( 'intact-inline-style', 'intact_dynamic_style' );
			$theme_dynamic_css = apply_filters( 'intact-inline-style', '' );

			if ( class_exists ( 'WooCommerce' ) ) {
				wp_add_inline_style('woocommerce', $theme_dynamic_css);
			} else if ( class_exists( 'KEYDESIGN_ADDON_CLASS' ) ) {
				wp_add_inline_style('kd_addon_style', $theme_dynamic_css);
			} else {
		    wp_add_inline_style('keydesign-style', $theme_dynamic_css);
			}

			if( '' != intact_get_option( 'tek-javascript') ) {
				wp_add_inline_script( 'intact-scripts', intact_get_option( 'tek-javascript') );
			}

			// Load Adobe Typekit fonts
			if ( intact_get_option( 'tek-typekit' ) ) {
				wp_register_script( 'intact-typekit', '//use.typekit.net/'.esc_js( intact_get_option( 'tek-typekit' ) ).'.js', array(), INTACT_THEME_VERSION, true );
				wp_enqueue_script( 'intact-typekit' );
				wp_add_inline_script( 'intact-typekit', 'try{Typekit.load({ async: true });}catch(e){}' );
			}

		}
	}
	add_action( 'wp_enqueue_scripts', 'intact_enqueue_scripts' );

	if( ! function_exists( 'intact_enqueue_admin' ) ) {
		function intact_enqueue_admin() {
			wp_enqueue_style( 'intact-admin-css', INTACT_THEME_URI . 'core/assets/css/admin-styles.css', '', '' );
		}
	}
	add_action( 'admin_enqueue_scripts', 'intact_enqueue_admin' );

// ------------------------------------------------------------------------
// Theme Setup
// ------------------------------------------------------------------------

	if( ! function_exists( 'intact_setup' ) ) {
		function intact_setup(){
			if ( function_exists( 'add_theme_support' ) ) {
				// Add multilanguage support
				load_theme_textdomain( 'intact', INTACT_THEME_DIR . 'languages' );

				// Add theme support for feed links
				add_theme_support( 'automatic-feed-links' );

				// Manage the document title tag
				add_theme_support( 'title-tag' );

				// Add theme support for menus
				if ( function_exists( 'register_nav_menus' ) ) {
					register_nav_menus(
						array(
						  'keydesign-header-menu' => __( 'Header Menu', 'intact' ),
							'keydesign-footer-menu' => __( 'Footer Menu', 'intact' ),
						)
					);
				}

				// Enable support for Blog Posts Thumbnails
				add_theme_support( 'post-thumbnails' );

				// Selective Refresh Support for Widgets
				add_theme_support( 'customize-selective-refresh-widgets' );

				// Enable support for WooCommerce
				add_theme_support( 'woocommerce', array(
					'thumbnail_image_width' => 400,
					'gallery_thumbnail_image_width' => 400,
					'single_image_width' => 800,
				) );
				add_theme_support( 'wc-product-gallery-lightbox' );
			}
		}
	}
	add_action( 'after_setup_theme', 'intact_setup' );

// ------------------------------------------------------------------------
// Content Width
// ------------------------------------------------------------------------

	if( ! function_exists( 'intact_set_content_width' ) ) {
		function intact_set_content_width() {
			global $content_width;
			if ( ! isset( $content_width ) ) {
				$content_width = apply_filters( 'intact_content_width', 1240 );
			}
		}
	}
	add_action( 'wp', 'intact_set_content_width' );

// ------------------------------------------------------------------------
// Main menu custom child pages attribute
// ------------------------------------------------------------------------

	if( ! function_exists( 'intact_onepage_nav_class' ) ) {
		function intact_onepage_nav_class($classes, $item){
			$themetek_menu_locations = get_nav_menu_locations();
			$themetek_pageid = get_post_meta( $item->ID, '_menu_item_object_id', true );
			$themetek_parrent_bool = get_page( $themetek_pageid );
			if ( ! empty($themetek_parrent_bool) && is_a($themetek_parrent_bool, 'WP_Post') ) {
				if($themetek_parrent_bool->post_parent) {
					$classes[] = 'one-page-link';
				}
			}

			return $classes;
		}
	}
	add_filter('nav_menu_css_class' , 'intact_onepage_nav_class' , 10 , 2);

// ------------------------------------------------------------------------
// Blog functionality
// ------------------------------------------------------------------------

	// Custom blog navigation
	if( ! function_exists( 'intact_blog_prev_link' ) ) {
		function intact_blog_prev_link( $output ) {
				return str_replace( '<a href=', '<a class="prev" href=', $output );
		}
	}
	add_filter( 'previous_post_link', 'intact_blog_prev_link' );

	if( ! function_exists( 'intact_blog_next_link' ) ) {
		function intact_blog_next_link( $output ) {
				return str_replace( '<a href=', '<a class="next" href=', $output );
		}
	}
	add_filter('next_post_link', 'intact_blog_next_link');

	// Excerpt length
	if( ! function_exists( 'intact_excerpt_length' ) ) {
		function intact_excerpt_length( $length ) {
			return 23;
		}
	}
	add_filter('excerpt_length', 'intact_excerpt_length');

// ------------------------------------------------------------------------
// Output Theme Options custom code
// ------------------------------------------------------------------------

if( ! function_exists( 'intact_dynamic_style' ) ) {
		function intact_dynamic_style() {
				// Get Theme Options custom CSS
				ob_start();
				include_once( INTACT_THEME_DIR . 'core/dynamic-styles.php' );
				$dynamic_css = ob_get_clean();

				// Get VC dynamic CSS
				$homepage_id = get_the_ID();
				$homepage_args = array('post_type'=>'page','posts_per_page'=>-1,'post_parent'=>$homepage_id,'post__not_in'=>array($homepage_id),'order'=>'ASC','orderby'=>'menu_order');
				$parent_page = new WP_Query( $homepage_args );
				while( $parent_page->have_posts() ) {
					$parent_page->the_post();
					$current_id = get_the_ID();
					wp_reset_postdata();
					if  ( $current_id ) {
						$shortcodes_custom_css = get_post_meta( $current_id, '_wpb_shortcodes_custom_css', true );
						if ( ! empty( $shortcodes_custom_css ) ) {
							$dynamic_css .= $shortcodes_custom_css;
						}
					}
				}

				// Get theme custom CSS
				$custom_css = intact_get_option( 'tek-css' );
				if ( '' != $custom_css ) {
					$dynamic_css .= $custom_css;
				}

				$dynamic_css = intact_compress_css( $dynamic_css );
				return $dynamic_css;
		}
	}

// ------------------------------------------------------------------------
// Force Visual Composer to initialize as "built into the theme".
// ------------------------------------------------------------------------

	if( class_exists( 'WPBakeryShortCode' ) ) {
		if( ! function_exists( 'intact_vc_set_as_theme' ) ) {
			function intact_vc_set_as_theme() {
				vc_set_as_theme($disable_updater = true);
			}
		}
	}
	add_action( 'vc_before_init', 'intact_vc_set_as_theme' );

// ------------------------------------------------------------------------
// Load maintenance page template
// ------------------------------------------------------------------------

	if( ! function_exists( 'intact_maintenance_mode' ) ) {
		function intact_maintenance_mode( $template ) {
			if ( ! class_exists( 'ReduxFramework' ) ) {
				return $template;
			}

			$new_template = locate_template( array( '/core/templates/maintenance-page-template.php' ) );

			if ( intact_get_option( 'tek-maintenance-mode' ) && !is_user_logged_in() ) {
				return $new_template;
			}

			return $template;
		}
	}
	add_action( 'template_include', 'intact_maintenance_mode', 1 );

// ------------------------------------------------------------------------
// Deactivate old plugins on theme activation
// ------------------------------------------------------------------------

	if( ! function_exists( 'intact_deactivate_old_plugins' ) ) {
		function intact_deactivate_old_plugins() {
			if( class_exists('OCDI_Plugin') ) {
				deactivate_plugins('one-click-demo-import/one-click-demo-import.php');
			}
			deactivate_plugins('intact-framework/intact-framework.php');
		}
	}
	add_action('admin_init','intact_deactivate_old_plugins');
