<?php
/**
 * Helper functions for Intact Theme.
 *
 * @package Intact
 * @since 2.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Fire the wp_body_open action. Backward compatibility for WordPress versions < 5.2
 */
if ( ! function_exists( 'wp_body_open' ) ) {
	function wp_body_open() {
		do_action( 'wp_body_open' );
  }
}

/**
 * Return Theme options.
 */
 if ( ! function_exists( 'intact_get_option' ) ) {
  function intact_get_option( $option, $default = '' ) {
 	 global $redux_ThemeTek;

 	 if ( empty( $redux_ThemeTek ) ) {
 		 if ( is_multisite() ) {
 			 $redux_ThemeTek = get_blog_option( get_current_blog_id(), 'redux_ThemeTek' );
 		 } else {
 			 $redux_ThemeTek = get_option( 'redux_ThemeTek' );
 		 }
 	 }

 	 if ( ( isset( $redux_ThemeTek[$option] ) && $redux_ThemeTek[$option] === '0') || !empty( $redux_ThemeTek[$option] ) ) {
 		 return $redux_ThemeTek[$option];
 	 } else {
 		 return $default;
 	 }

  }
 }

if ( ! function_exists( 'intact_compress_css' ) ) {
	function intact_compress_css( $css = '' ) {
			if ( ! empty( $css ) ) {
				$css = preg_replace( '!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css );
				$css = str_replace( array( "\r\n", "\r", "\n", "\t", '  ', '    ', '    ' ), '', $css );
				$css = str_replace( ', ', ',', $css );
			}
			return $css;
	}
}

if ( ! function_exists( 'intact_update_theme_version' ) ) {
	function intact_update_theme_version() {
		if ( true === intact_new_install() ) {
			add_option( 'intact-version', INTACT_THEME_VERSION, '', false );
			add_option( 'intact-legacy-version', 'no', '', false );
		} else {
			update_option( 'intact-version', INTACT_THEME_VERSION );
		}
	}
}
add_action( 'admin_init', 'intact_update_theme_version' );

if ( ! function_exists( 'intact_new_install' ) ) {
	function intact_new_install() {
			$version = get_option( 'intact-version', false );
			if ( false === $version ) {
				return true;
			}
			return false;
		}
}

if ( ! function_exists( 'intact_old_version' ) ) {
	function intact_old_version() {
		$version = get_option( 'intact-version', false );
		if ( false === $version ) {
			return true;
		} elseif ( version_compare( $version, '2.2', '<' ) ) {
			return true;
		}
		return false;
	}
}

if ( ! function_exists( 'intact_allowed_html_tags' ) ) {
	function intact_allowed_html_tags() {
		$allowed_tags = array(
			 'a' => array(
				 'class' => array(),
				 'href'  => array(),
				 'rel'   => array(),
				 'title' => array(),
				 'target' => array(),
			 ),
			 'b' => array(),
			 'br' => array(),
			 'div' => array(
				 'class' => array(),
				 'title' => array(),
				 'style' => array(),
			 ),
			 'em' => array(),
			 'h1' => array(),
			 'h2' => array(),
			 'h3' => array(),
			 'h4' => array(),
			 'h5' => array(),
			 'h6' => array(),
			 'i' => array(),
			 'img' => array(
				 'alt'    => array(),
				 'class'  => array(),
				 'height' => array(),
				 'src'    => array(),
				 'width'  => array(),
			 ),
			 'p' => array(
				 'class' => array(),
			 ),
			 'span' => array(
				 'class' => array(),
				 'title' => array(),
				 'style' => array(),
			 ),
			 'strong' => array(),
		 );

		 return $allowed_tags;
	 }
 }
