<?php

if ( ! function_exists( 'keydesign_demo_import_files' ) ) {
  function keydesign_demo_import_files() {
    return array(
      array(
        'import_file_name'             => 'Business',
        'categories'                   => '',
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demos/business/demo-content.xml',
        'local_import_widget_file'     => plugin_dir_path( __FILE__ ) . 'demos/general/widgets.wie',
        'local_import_redux'           => array(
          array(
            'file_path'   => plugin_dir_path( __FILE__ ) . 'demos/business/theme-options.json',
            'option_name' => 'redux_ThemeTek',
          ),
        ),
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'screenshots/business.jpg',
        'preview_url'                  => 'https://www.keydesign-themes.com/intact/business/',
      ),
      array(
        'import_file_name'             => 'Conference',
        'categories'                   => '',
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demos/conference/demo-content.xml',
        'local_import_widget_file'     => plugin_dir_path( __FILE__ ) . 'demos/general/widgets.wie',
        'local_import_redux'           => array(
          array(
            'file_path'   => plugin_dir_path( __FILE__ ) . 'demos/conference/theme-options.json',
            'option_name' => 'redux_ThemeTek',
          ),
        ),
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'screenshots/conference.jpg',
        'preview_url'                  => 'https://www.keydesign-themes.com/intact/conference/',
      ),
      array(
        'import_file_name'             => 'Corporate',
        'categories'                   => '',
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demos/corporate/demo-content.xml',
        'local_import_widget_file'     => plugin_dir_path( __FILE__ ) . 'demos/general/widgets.wie',
        'local_import_redux'           => array(
          array(
            'file_path'   => plugin_dir_path( __FILE__ ) . 'demos/corporate/theme-options.json',
            'option_name' => 'redux_ThemeTek',
          ),
        ),
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'screenshots/corporate.jpg',
        'preview_url'                  => 'https://www.keydesign-themes.com/intact/corporate/',
      ),
      array(
        'import_file_name'             => 'Creative Agency',
        'categories'                   => '',
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demos/creative-agency/demo-content.xml',
        'local_import_widget_file'     => plugin_dir_path( __FILE__ ) . 'demos/general/widgets.wie',
        'local_import_redux'           => array(
          array(
            'file_path'   => plugin_dir_path( __FILE__ ) . 'demos/creative-agency/theme-options.json',
            'option_name' => 'redux_ThemeTek',
          ),
        ),
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'screenshots/creative-agency.jpg',
        'preview_url'                  => 'https://www.keydesign-themes.com/intact/creative-agency/',
      ),
      array(
        'import_file_name'             => 'Digital Product',
        'categories'                   => '',
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demos/digital-product/demo-content.xml',
        'local_import_widget_file'     => plugin_dir_path( __FILE__ ) . 'demos/general/widgets.wie',
        'local_import_redux'           => array(
          array(
            'file_path'   => plugin_dir_path( __FILE__ ) . 'demos/digital-product/theme-options.json',
            'option_name' => 'redux_ThemeTek',
          ),
        ),
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'screenshots/digital-product.jpg',
        'preview_url'                  => 'https://www.keydesign-themes.com/intact/digital-product/',
      ),
      array(
        'import_file_name'             => 'Landing Page',
        'categories'                   => '',
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demos/landing-page/demo-content.xml',
        'local_import_widget_file'     => plugin_dir_path( __FILE__ ) . 'demos/general/widgets.wie',
        'local_import_redux'           => array(
          array(
            'file_path'   => plugin_dir_path( __FILE__ ) . 'demos/landing-page/theme-options.json',
            'option_name' => 'redux_ThemeTek',
          ),
        ),
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'screenshots/landing-page.jpg',
        'preview_url'                  => 'https://www.keydesign-themes.com/intact/landing-page/',
      ),
      array(
        'import_file_name'             => 'Marketing Agency',
        'categories'                   => '',
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demos/marketing-agency/demo-content.xml',
        'local_import_widget_file'     => plugin_dir_path( __FILE__ ) . 'demos/general/widgets.wie',
        'local_import_redux'           => array(
          array(
            'file_path'   => plugin_dir_path( __FILE__ ) . 'demos/marketing-agency/theme-options.json',
            'option_name' => 'redux_ThemeTek',
          ),
        ),
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'screenshots/marketing-agency.jpg',
        'preview_url'                  => 'https://www.keydesign-themes.com/intact/marketing-agency/',
      ),
      array(
        'import_file_name'             => 'Mobile App',
        'categories'                   => '',
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demos/mobile-app/demo-content.xml',
        'local_import_widget_file'     => plugin_dir_path( __FILE__ ) . 'demos/general/widgets.wie',
        'local_import_redux'           => array(
          array(
            'file_path'   => plugin_dir_path( __FILE__ ) . 'demos/mobile-app/theme-options.json',
            'option_name' => 'redux_ThemeTek',
          ),
        ),
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'screenshots/mobile-app.jpg',
        'preview_url'                  => 'https://www.keydesign-themes.com/intact/mobile-app/',
      ),
      array(
        'import_file_name'             => 'Shop Classic',
        'categories'                   => '',
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demos/shop-classic/demo-content.xml',
        'local_import_widget_file'     => plugin_dir_path( __FILE__ ) . 'demos/general/widgets.wie',
        'local_import_redux'           => array(
          array(
            'file_path'   => plugin_dir_path( __FILE__ ) . 'demos/shop-classic/theme-options.json',
            'option_name' => 'redux_ThemeTek',
          ),
        ),
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'screenshots/shop-classic.jpg',
        'preview_url'                  => 'https://www.keydesign-themes.com/intact/shop-classic/',
      ),
      array(
        'import_file_name'             => 'Simple Portfolio',
        'categories'                   => '',
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demos/simple-portfolio/demo-content.xml',
        'local_import_widget_file'     => plugin_dir_path( __FILE__ ) . 'demos/general/widgets.wie',
        'local_import_redux'           => array(
          array(
            'file_path'   => plugin_dir_path( __FILE__ ) . 'demos/simple-portfolio/theme-options.json',
            'option_name' => 'redux_ThemeTek',
          ),
        ),
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'screenshots/simple-portfolio.jpg',
        'preview_url'                  => 'https://www.keydesign-themes.com/intact/simple-portfolio/',
      ),
      array(
        'import_file_name'             => 'Startup',
        'categories'                   => '',
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demos/startup/demo-content.xml',
        'local_import_widget_file'     => plugin_dir_path( __FILE__ ) . 'demos/general/widgets.wie',
        'local_import_redux'           => array(
          array(
            'file_path'   => plugin_dir_path( __FILE__ ) . 'demos/startup/theme-options.json',
            'option_name' => 'redux_ThemeTek',
          ),
        ),
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'screenshots/startup.jpg',
        'preview_url'                  => 'https://www.keydesign-themes.com/intact/startup/',
      ),
      array(
        'import_file_name'             => 'Internal Pages',
        'categories'                   => '',
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demos/internal-pages/demo-content.xml',
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'screenshots/internal-pages.jpg',
      ),

    );
  }
}
add_filter( 'pt-ocdi/import_files', 'keydesign_demo_import_files' );

// Automatically assign "Front page", "Posts page" and menu locations after the importer is done
// Import Revolution Slider if plugin is active
if ( ! function_exists( 'keydesign_demo_after_import' ) ) {
  function keydesign_demo_after_import($selected_import) {
  	// Assign menus to their locations.
  	$main_menu = get_term_by( 'name', 'Main menu', 'nav_menu' );
    $footer_menu = get_term_by( 'name', 'Footer menu', 'nav_menu' );

  	set_theme_mod( 'nav_menu_locations', array(
  			'keydesign-header-menu' => $main_menu->term_id,
			'keydesign-footer-menu' => $footer_menu->term_id,
  		)
  	);

  	// Assign front page and posts page (blog page).
  	$front_page_id = get_page_by_title( 'Home' );
  	$blog_page_id  = get_page_by_title( 'Blog' );

  	update_option( 'show_on_front', 'page' );
  	update_option( 'page_on_front', $front_page_id->ID );
  	update_option( 'page_for_posts', $blog_page_id->ID );

    // Configure permalinks
    global $wp_rewrite;
  	$wp_rewrite->set_permalink_structure( '/%postname%/' );

    // Import Slider Revolution

    if ( class_exists( 'RevSlider' ) ) {
      if ( 'Business' === $selected_import['import_file_name'] ) {
        $slider_array = array( plugin_dir_path( __FILE__ ) . 'demos/revslider/business-slider.zip' );
      } elseif ( 'Corporate' === $selected_import['import_file_name'] ) {
        $slider_array = array( plugin_dir_path( __FILE__ ) . 'demos/revslider/corporate-slider.zip' );
      } elseif ( 'Creative Agency' === $selected_import['import_file_name'] ) {
        $slider_array = array( plugin_dir_path( __FILE__ ) . 'demos/revslider/creative-agency-slider.zip' );
      } elseif ( 'Marketing Agency' === $selected_import['import_file_name'] ) {
        $slider_array = array( plugin_dir_path( __FILE__ ) . 'demos/revslider/marketing-agency-slider.zip' );
      } elseif ( 'Mobile App' === $selected_import['import_file_name'] ) {
        $slider_array = array( plugin_dir_path( __FILE__ ) . 'demos/revslider/mobile-app-slider.zip' );
      } elseif ( 'Simple Portfolio' === $selected_import['import_file_name'] ) {
        $slider_array = array( plugin_dir_path( __FILE__ ) . 'demos/revslider/portfolio-slider.zip' );
      } elseif ( 'Shop Classic' === $selected_import['import_file_name'] ) {
        $slider_array = array( plugin_dir_path( __FILE__ ) . 'demos/revslider/shop-classic-slider.zip' );
      } elseif ( 'Startup' === $selected_import['import_file_name'] ) {
        $slider_array = array( plugin_dir_path( __FILE__ ) . 'demos/revslider/startup-slider.zip' );
      }

       $slider = new RevSlider();

       foreach($slider_array as $filepath){
         $slider->importSliderFromPost(true,true,$filepath);
       }

       echo ' Slider processed';
    }
  }
}
add_action( 'pt-ocdi/after_import', 'keydesign_demo_after_import' );

// Disable generation of smaller images (thumbnails) during the content import
add_filter( 'pt-ocdi/regenerate_thumbnails_in_content_import', '__return_false' );

// Disable the branding notice
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );
?>
