jQuery(document).ready(function($) {

  (function($, win) {
    $.fn.inViewport = function(cb) {
      return this.each(function(i, el) {
        function visPx() {
          var H = $(this).height(),
            r = el.getBoundingClientRect(),
            t = r.top,
            b = r.bottom;
          return cb.call(el, Math.max(0, t > 0 ? H - t : (b < H ? b : H)));
        }
        visPx();
        $(win).on("resize scroll", visPx);
      });
    };
  }(jQuery, window));




  $(".kd-animated, .portfolio-item, .play-video, .toggle-map").inViewport(function(px) {
    if (px) $(this).addClass("kd-animate");
  });



  /* ------------------------------------------------------------------------
    COUNTDOWN
   ------------------------------------------------------------------------*/
$('.countdown').each(function (index, value){
 var text_days = $(this).attr( "data-text-days" );
 var text_hours = $(this).attr( "data-text-hours" );
 var text_minutes = $(this).attr( "data-text-minutes" );
 var text_seconds = $(this).attr( "data-text-seconds" );

 var count_year = $(this).attr( "data-count-year" );
 var count_month = $(this).attr( "data-count-month" );
 var count_day = $(this).attr( "data-count-day" );
 var count_date = count_year + '/' + count_month + '/' + count_day;
  $(this).countdown(count_date, function(event) {
    $(this).html(
      event.strftime('<span class="CountdownContent">%D<span class="CountdownLabel">'+text_days+'</span></span><span class="CountdownSeparator">:</span><span class="CountdownContent">%H <span class="CountdownLabel">'+text_hours+'</span></span><span class="CountdownSeparator">:</span><span class="CountdownContent">%M <span class="CountdownLabel">'+text_minutes+'</span></span><span class="CountdownSeparator">:</span><span class="CountdownContent">%S <span class="CountdownLabel">'+text_seconds+'</span></span>')
    );
  });
});


  /* ------------------------------------------------------------------------
    PIE CHART
   ------------------------------------------------------------------------*/

  jQuery(".kd_pie_chart .kd_chart").each(function (index, value){
    jQuery(this).appear(function() {
      jQuery(this).easyPieChart({
      easing: "easeInQuad",
      barColor: "#000",
      trackColor: "#e5e5e5",
      animate: 2000,
      size: "160",
      lineCap: 'square',
      lineWidth: "2",
      scaleColor: false,
      onStep: function(from, to, percent) {
        jQuery(this.el).find(".pc_percent").text(Math.round(percent));
      }
      });
    });
    var chart = window.chart = jQuery("kd_pie_chart .kd_chart").data("easyPieChart");
  });

  /* ------------------------------------------------------------------------
    GOOGLE MAP
   ------------------------------------------------------------------------*/

  $('.contact-map-container .toggle-map').click(function() {
    $('.contact-map-container').toggleClass('full-map');
  });

  /* ------------------------------------------------------------------------
      AUTO PLAY YOUTUBE VIDEO ELEMENT
   ------------------------------------------------------------------------*/

  function autoPlayYouTubeModal() {
    var trigger = $("body").find('[data-toggle="modal"]');
      trigger.click(function() {
      var theModal = $(this).data("target");
      videoSRC = $(theModal + ' iframe').attr('src');
      videoSRCauto = videoSRC + "?autoplay=1&rel=0&showinfo=0";
      $(theModal + ' iframe').attr('src', videoSRCauto);
      $(theModal + ' button.close').click(function() {
        $(theModal + ' iframe').attr('src', videoSRC);
      });
      $('.modal').click(function() {
        $(theModal + ' iframe').attr('src', videoSRC);
      });
    });
  }
  autoPlayYouTubeModal();


  function autoPlayVideoModal() {
    var trigger = $("body").find('[data-toggle="modal"]');
      trigger.click(function() {
      var theModal = $(this).data("target");
      if ($(theModal + ' .video-modal-local').length) {
        $(theModal + ' .video-modal-local')[0].play();
      }
    });
  }
  autoPlayVideoModal();


  $('body').on('hidden.bs.modal', '.modal', function () {
    $('video').trigger('pause');
  });

  /* ------------------------------------------------------------------------
    BOOK PREVIEW ELEMENT
   ------------------------------------------------------------------------*/

  if ($(".bp-content").length) {
    setInterval(function(){
      var pos = $(".bp-content").scrollTop();
      $(".bp-content").scrollTop(pos + 1);
  }, 30)
  }

  /* ------------------------------------------------------------------------
    TABS ELEMENT
   ------------------------------------------------------------------------*/

  $('.features-tabs li.tab').appendTo('.features-tabs .tabs');
  // var tabsnumber = $('.tabs > li.tab').length;
  // $('.tabs li.tab').css('width',100/tabsnumber + '%');

  if ($(".features-tabs").length) {
    $('.features-tabs').easytabs({
      updateHash: false,
      animationSpeed: 'fast',
      transitionIn: 'fadeIn'
    });
  }

  /* ------------------------------------------------------------------------
    FEATURED CONTENT ELEMENT
   ------------------------------------------------------------------------*/
  $('.featured_content_child').on('mouseenter', function() {
    $('.featured_content_child').removeClass('active-elem');
    $(this).addClass('active-elem');
  });

});


jQuery(window).on('load', function() {

  /* ------------------------------------------------------------------------
  MASONRY GALLERY ELEMENT
 ------------------------------------------------------------------------*/

  if (jQuery('.mg-gallery').length > 0) {
    jQuery('.mg-gallery').each(function() {
      var msnry = new Masonry(this, {
        itemSelector: '.mg-single-img',
        columnWidth: '.mg-sizer',
        percentPosition: true,
        gutter: 5
      });
    });
    var classes = '.vc_tta-tabs-list .vc_tta-tab,' + '.vc_pagination .vc_pagination-item';
    jQuery('body').on('click', classes,
      function() {
        setInterval(function(){
        var reloadMasonry = jQuery('.vc_active .mg-gallery').masonry({
            itemSelector: '.mg-single-img',
            columnWidth: '.mg-sizer',
            percentPosition: true,
            gutter: 5
        });
        reloadMasonry.masonry("reloadItems");
        reloadMasonry.masonry('layout');
        },200);
      });
  }

  /* ------------------------------------------------------------------------
  ALERT BOX ELEMENT
 ------------------------------------------------------------------------*/

   jQuery('.kd-alertbox .ab-close').on('click', function(e) {
     e.preventDefault();
     jQuery(this).closest('.kd-alertbox').hide(200);
   });

  /* ------------------------------------------------------------------------
  COLOR SWITCH
 ------------------------------------------------------------------------*/

  if (jQuery(".slider.color-swtich").length) {
    jQuery(".slider.color-swtich").owlCarousel({
      navigation: false,
      pagination: true,
      responsive: false,
      autoPlay: 5000,
      transitionStyle : "fade",
      items: 1,
    });
    var elem_count = 0;
    jQuery('.color-swtich .color-swtich-content').each(function (index, value){
       var elem_color = ( jQuery(this).attr("data-color") );
       jQuery('.color-swtich .owl-controls .owl-page span').eq(elem_count++).css( "background", elem_color );
    });

}

});
